# ------------------------------------------------------------------------------
# Program Name: datasetjson_adam.R
# Description :
# CDISCDataset-JSON`̃f[^ZbgR̃f[^t[ƂēǂݍރvOB
# L̗łgithubɌJꂽTvf[^ǂݍłB
# ܂AeSAS transportt@Ci.xptjǂݍ݁ADataset-JSON`ō쐬ĂB
# Dataset-JSON쐬̍ۂɂ́AJSONt@CXĂ^f[^𗘗pĂB
# Author: JPMA TF5 2023
# ------------------------------------------------------------------------------

library(datasetjson)
library(jsonlite)
library(haven)
library(diffdf)

#### Read the contents from Dataset-JSON file ####
jsonfilename <- "https://raw.githubusercontent.com/cdisc-org/DataExchange-DatasetJson/master/examples/adam/adadas.json"
json_data <- read_dataset_json(jsonfilename)

#### Read the contents from SAS transport file (.xpt) file ####
xptfilename <- "https://raw.githubusercontent.com/cdisc-org/DataExchange-DatasetJson/master/examples/adam/adadas.xpt"
xpt_data <- read_xpt(xptfilename)

#### Write the contents from SAS transport file (.xpt) file into Dataset-JSON file ####
json_metadata <- fromJSON(jsonfilename)
xpt_json <- dataset_json(xpt_data, "IG.ADADAS", "ADADAS", "ADAS-Cog Analysis", json_metadata$clinicalData$itemGroupData$IG.ADADAS$items)
write_dataset_json(xpt_json,"xpt_json.json")

#### Read the contents from new Dataset-JSON file and compare ####
json_data2 <- read_dataset_json("xpt_json.json")
diffdf(json_data, json_data2)
